' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa AppointmentManager odpowiada za sprawdzanie, pobieranie i dodawanie rezerwacji.
''' Potrafi take pobra informacje o dostpnoci rezerwacji.
''' </summary>
''' <remarks>Poniewa klasa ta zawiera tylko metody wspdzielone, jej konstruktor zosta oznaczony jako prywatny, wic nie mona tworzy jej egzemplarzy.</remarks>
Public Class AppointmentManager

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy AppointmentManager.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca wszystkie obiekty rezerwacji oraz rezerwacje dla okreslonego dnia w postaci dwch tabel danych poczonych relacj wewntrz DataSet, wywoujc metod z klasy AppointmentManagerDB.
  ''' </summary>
  ''' <param name="selectedDate">Dzie, dla ktrego rezerwacje maj by pobrane.</param>
  ''' <returns>DataSet z dwoma tabelami, jedn z obiektami rezerwacji, drug z powizanymi rezerwacjami.</returns>
  Public Shared Function GetAppointmentList(ByVal selectedDate As DateTime) As DataSet
    Return AppointmentManagerDB.GetAppointmentList(selectedDate)
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy obiekt Appointment w oparciu o jego identyfikator metod z klasy AppointmentManagerDB class.
  ''' </summary>
  ''' <param name="id">Identyfikator rezerwacji w bazie danych.</param>
  ''' <returns>dana rezerwacja, jeli pozycj znaleziono w bazie danych lub <see langword="null" /> jeli pozycji nie mona byo znale.</returns>
  Public Shared Function GetAppointment(ByVal id As Integer) As Appointment
    Return AppointmentManagerDB.GetAppointment(id)
  End Function

  ''' <summary>
  ''' Sprawdza poprawno biecej rezerwacji, aby upewni si, e nie koliduje z innymi 
  ''' rezerwacjami dla danego obiektu rezerwacji.
  ''' </summary>
  ''' <param name="myAppointment">Rezerwacja, ktrej poprawno ma by sprawdzona.</param>
  ''' <returns>Zwraca True, gdy rezerwacja nie koliduje z isniejc rezerwacj, a False w przeciwnym razie.</returns>
  Public Shared Function CheckAppointment(ByVal myAppointment As Appointment) As Boolean
    Return AppointmentManagerDB.CheckAppointment(myAppointment)
  End Function

  ''' <summary>
  ''' Zapisuje rezerwacj w bazie danych wywoujc metod z klasy AppointmentManagerDB.
  ''' </summary>
  ''' <param name="myAppointment">Rezerwacja, ktra ma by zapisana.</param>
  ''' <returns>Zwraca True, jeli dana data i czas bya dostpna i rezerwacja zostaa zapisana pomylnie.
  ''' Zwraca False w przeciwnym razie.</returns>
  Public Shared Function CreateAppointment(ByVal myAppointment As Appointment) As Boolean
    Return AppointmentManagerDB.CreateAppointment(myAppointment)
  End Function

  ''' <summary>
  ''' Zwraca wszystkie obiekty rezerwacji i rezerwacje jako dwie tabele z danymi poaczone relacj wewntrz DataSet wywoujc metod z klasy AppointmentManagerDB.
  ''' </summary>
  ''' <param name="selectedDate">Dzie dla ktrego rezerwacje maj by pobrane.</param>
  ''' <returns>DataSet z dwiema tabelami, jedna z obiektami rezerwacji, druga z powizanymi rezerwacjami.</returns>
  Public Shared Function GetTimeSheet(ByVal selectedDate As DateTime) As DataSet
    Return AppointmentManagerDB.GetTimeSheet(selectedDate)
  End Function

End Class
